import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * <p>Title: Graph User</p>
 * <p>Description: Frame to hold the graph and GUI controls</p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: </p>
 * @author Chris Bolduc
 * @version 1.0
 */

public class GraphUser extends JApplet implements ActionListener
{
  private Graph graph;
  private JTextField fx1Field, fx2Field, fx3Field;
  private JButton graphButton;
  private JPanel buttonPanel;

  public void init()
  {
    this.getContentPane().setLayout(new BorderLayout());
    graph = new Graph("(x-25)^3/5000-50", "x", "(x+25)^2/100", this.getWidth(),
                      this.getHeight());
    this.getContentPane().add(graph);

    buttonPanel = new JPanel(new GridLayout(4,2));
    buttonPanel.add(new JLabel("f(x)1 = "));
    buttonPanel.add(fx1Field = new JTextField("(x-25)^3/5000-50", 15));
    buttonPanel.add(new JLabel("f(x)2 = "));
    buttonPanel.add(fx2Field = new JTextField("x", 15));
    buttonPanel.add(new JLabel("f(x)3 = "));
    buttonPanel.add(fx3Field = new JTextField("(x+25)^2/100", 15));
    buttonPanel.add(new JLabel(""));
    buttonPanel.add(graphButton = new JButton("Graph!"));
    graphButton.addActionListener(this);

    this.getContentPane().add(buttonPanel, "South");
  }

  public void actionPerformed(ActionEvent e)
  {
    if (e.getSource() == graphButton)
    {
      this.remove(graph);
      graph = new Graph(fx1Field.getText(), fx2Field.getText(),
                        fx3Field.getText(), this.getWidth(),
                        this.getHeight());
      this.getContentPane().add(graph, "North");
      repaint();
    }
  }
}
