import java.awt.*;
import javax.swing.*;

/**
 * <p>Title: Graph</p>
 * <p>Description: Utility to graph stuff in the XY plane</p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: </p>
 * @author Chris Bolduc
 * @version 1.0
 */

public class Graph extends JPanel
{
  private final int WIDTH, HEIGHT;
  private String fx1, fx2, fx3;

  public Graph(String graph1, String graph2, String graph3, int width, int height)
  {
    WIDTH = width;
    HEIGHT = height;
    setSize(WIDTH, HEIGHT);
    fx1 = graph1;
    fx2 = graph2;
    fx3 = graph3;
  }

  public void paintComponent(Graphics g)
  {
    Dimension size = this.getSize();
    g.setColor(getBackground()); // Clear the drawing area
    g.setClip(0, 0, size.width, size.height);
    g.fillRect(0, 0, size.width, size.height);
    g.setClip(20, 20, size.width - 40, size.height - 40); // Reset the clip region
    g.translate(size.width / 2, size.height / 2); // Place origin at middle
    g.setColor(Color.black);
    drawXYAxes(g); // Draw the X and Y axes
    graphEquation(g, fx1);
    graphEquation(g, fx2);
    graphEquation(g, fx3);
  } // paintComponent()

  private void drawXYAxes(Graphics g)
  {
    Dimension size = this.getSize(); // Get the panel's size
    int hBound = size.width / 2; // Use it to set the bounds
    int vBound = size.height / 2;
    int tic = size.width / 100;

    g.drawLine( -hBound, 0, hBound, 0); // Draw X-axis
    for (int k = -hBound; k <= hBound; k += 10)
      g.drawLine(k, tic, k, -tic);
    g.drawLine(0, vBound, 0, -vBound); // Draw Y-axis
    for (int k = -vBound; k <= vBound; k += 10)
      g.drawLine( -tic, k, +tic, k);
  } // drawXYAxes()

  public void graphEquation(Graphics g, String equation)
  {
    Dimension size = this.getSize(); // Get the panel's size
    int hBound = size.width / 2; // Use it to set the bounds
    int vBound = size.height / 2;

    g.setColor(Color.red);

    for (int x1 = 0; x1 <= hBound; x1++)
    { // Draw quadrants I and IV
      int x2 = x1 + 1;
      int y1 = (int) ParseEquation.parseEq(equation, x1),
          y2 = (int) ParseEquation.parseEq(equation, x2);

      if (y1 != Double.NaN && y2 != Double.NaN)
      { // If y is not undefined
        y1 = -y1; // Reverse y coordinate (cartesian)
        y2 = -y2;
        g.drawLine( (x1 - 1), (y1 - 1), (x2 - 1), (y2 - 1));
      }
    }

    for (int x1 = 0; x1 >= -hBound; x1--)
    { // Draw quadrants II and III
      int x2 = x1 + 1;
      int y1 = (int) ParseEquation.parseEq(equation, x1),
          y2 = (int) ParseEquation.parseEq(equation, x2);

      if (y1 != Double.NaN && y2 != Double.NaN)
      { // If y is not undefined
        y1 = -y1; // Reverse y coordinate (cartesian)
        y2 = -y2;
        g.drawLine( (x1 - 1), (y1 - 1), (x2 - 1), (y2 - 1));
      }
    }
  }
} // Graph
