#ifndef LOADTGA_H
#define LOADTGA_H

/* Some TGA Specs:
 * The first 18 bits are header information.
 * Bits #12 and 13 (zero indexed) are the (reversed) width of the image
 * Note the reversal of bits (So hex 0190 becomes 9001)
 * Bits #14 and 15 are the height
 * Sample:
 * 0000 0200 0000 0000 0000 0000 9001 7000 1800
 * 400x112 image (hex 0190x0070)
 */

// Loads a TGA image into an OpenGL mipmap.  Parameters:
// szFileName	The file name/path (can be a char* type)
// texid		The OpenGL texture ID used to identify it when mapping.
//				Use glBindTexture(GL_TEXTURE_2D, texid);
int load_gl_tga(char* szFileName, GLuint texid);

#endif
