#include <GL/glut.h>
#include <stdio.h>
#include <stdlib.h>
#include <windows.h>
#include "loadtga.h"

int load_gl_tga(char* szFileName, GLuint texid){
	int file_size;
	int width;
	int height;
	int bpp;
	unsigned char type[4];
	unsigned char info[7];
	unsigned char* tex; //array to hold data input
	unsigned char temp;
	int num; //loop variable
	FILE *file_ptr; //open the bitmap for reading

	if((file_ptr = fopen(szFileName, "r")) == NULL){
		printf("Error reading %s", szFileName);
		return 1;
	}

	fread(&type, sizeof(char), 3, file_ptr);
	fseek(file_ptr, 12, SEEK_SET);
	fread(&info, sizeof(char), 6, file_ptr);

	if(type[1] != 0 || (type[2] != 2 && type[2] != 3)){
		printf("TGA Error: Bad image type");
		return 1;
	}

	width		= info[0] + info[1] * 256;
	height		= info[2] + info[3] * 256;
	bpp			= info[4];
	file_size	= width * height * (bpp / 8);

	tex = (unsigned char*)malloc(file_size * sizeof(unsigned char));
	fread(tex, file_size, 1, file_ptr); //read data from bitmap
	fclose(file_ptr); //close the file

	glBindTexture(GL_TEXTURE_2D, texid); //select ID to store the texture
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	//glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
	//glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
	gluBuild2DMipmaps(GL_TEXTURE_2D,		// The target texture. Must be GL_TEXTURE_2D.
					  3,					// The number of color components in the texture.
					  width,
					  height,
					  GL_RGB,				// The data type of the pixel data.
					  GL_UNSIGNED_BYTE,
					  tex);
	// Free up temporary array space
	free(tex);
	return 0;
}
