#ifndef KEYPRESS_H
#define KEYPRESS_H

#define pi 3.1415926535897932384626433832795
#define INVERT_PITCH 1.0 // Set to -1.0 to disable

// Prototypes
void keypress(unsigned char key, int x, int y);

// Camera position and direction
float camera_x = 6.5;
float camera_y = 4.0;
float camera_z = 5.0;
float camera_theta = 0;
float camera_pitch = 0;
float move_speed = 0.1;
float turn_speed = 0.1;

// Implementation
void keypress(unsigned char key, int x, int y){
	switch(key){
	case 'W':
	case 'w':
		camera_z += -move_speed * cos(camera_theta);
		camera_x += -move_speed * sin(camera_theta);
		break;
	case 'S':
	case 's':
		camera_z += move_speed * cos(camera_theta);
		camera_x += move_speed * sin(camera_theta);
		break;
	case 'A':
	case 'a':
		camera_z += move_speed * cos(camera_theta - pi / 2);
		camera_x += move_speed * sin(camera_theta - pi / 2);
		break;
	case 'D':
	case 'd':
		camera_z += move_speed * cos(camera_theta + pi / 2);
		camera_x += move_speed * sin(camera_theta + pi / 2);
		break;
	case 'F':
	case 'f':
		camera_y += move_speed;
		break;
	case 'V':
	case 'v':
		camera_y += -move_speed;
		break;
	case 'J':
	case 'j':
		camera_theta += 2 * turn_speed;
		if(camera_theta >= 2 * pi){ camera_theta = 0.0; }
		break;
	case 'L':
	case 'l':
		camera_theta += 2 * -turn_speed;
		if(camera_theta >= 2 * pi){ camera_theta = 0.0; }
		break;
	case 'I':
	case 'i':
		camera_pitch += INVERT_PITCH * 10 * turn_speed;
		break;
	case 'K':
	case 'k':
		camera_pitch += INVERT_PITCH * 10 * -turn_speed;
		break;
	case '[':
		move_speed -= 0.1;
		break;
	case ']':
		move_speed += 0.1;
		break;
	case '{':
		turn_speed -= 0.01;
		break;
	case '}':
		turn_speed += 0.01;
		break;
	}
}

#endif
