/* CPSC 360 Programming Assignment 5
 * Cubestraveganza!
 * by Chris Bolduc
 * boldu101@chapman.edu
 */

#include <GL/glut.h>

// Prototypes I don't think are necessary.
//void init();
//void display();
//void reshape(int w, int h);

// globals
float angle = 0;
float x_rotate = 0.0;
float y_rotate = 1.0;
float z_rotate = 0.0;
float x_translate = 0.0;
float y_translate = 0.0;
float z_translate = 0.0;
float scale = 1.0;

// Initialize the drawing area
void init(){
	glClearColor(0.0, 0.0, 0.0, 0.0);
	glShadeModel(GL_FLAT);
	glOrtho(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
}

// Handles user menu calls.
// Puts the result in displayMode.
void menuFunction(int itemNum){
	switch(itemNum){
	case 1:
		x_rotate = 1.0;
		y_rotate = 0.0;
		z_rotate = 0.0;
		break;
	case 2:
		x_rotate = 0.0;
		y_rotate = 1.0;
		z_rotate = 0.0;
		break;
	case 3:
		x_rotate = 0.0;
		y_rotate = 0.0;
		z_rotate = 1.0;
		break;
	case 4:
		y_translate += 1.0;
		break;
	case 5:
		y_translate += -1.0;
		break;
	case 6:
		x_translate += -1.0;
		break;
	case 7:
		x_translate += 1.0;
		break;
	case 8:
		scale = 0.5;
		break;
	case 9:
		scale = 2.0;
		break;
	}
	glutPostRedisplay();
}

// Display the cube
void display(){
	int i;
	glPushMatrix();
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glColor3f(0.0, 1.0, 0.0);
	glLoadIdentity();
	gluLookAt(0.0, 0.0, 5.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);

	glTranslatef(x_translate, y_translate, z_translate);
	glRotatef(angle, x_rotate, y_rotate, z_rotate);
	glScalef(scale, scale, scale);
	glutWireCube(2.0);
	
	glPopMatrix();
	//glFlush();
	glutSwapBuffers();
	glutPostRedisplay();
}

// Adjusts viewing window when it is resized
void reshape(int w, int h){
	glViewport(0, 0, (GLsizei)w, (GLsizei)h);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glFrustum(-1.0, 1.0, -1.0, 1.0, 1.5, 20.0);
	glMatrixMode(GL_MODELVIEW);
}

// Rotates the cube when idle
void rotate(){
	angle += 1.0;
	if(angle >= 360.0){ angle = 0; }
	//glutPostRedisplay();
}

int main(int argc, char* argv[]){
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB);
	glutInitWindowSize(500, 500);
	glutInitWindowPosition(100, 100);
	glutCreateWindow("Cubestraveganza!");
	
	init();
	glutCreateMenu(menuFunction);
		glutAddMenuEntry("Rotate X-axis", 1);
		glutAddMenuEntry("Rotate Y-axis", 2);
		glutAddMenuEntry("Rotate Z-axis", 3);
		glutAddMenuEntry("Translate up", 4);
		glutAddMenuEntry("Translate down", 5);
		glutAddMenuEntry("Translate left", 6);
		glutAddMenuEntry("Translate right", 7);
		glutAddMenuEntry("Scale 1/2", 8);
		glutAddMenuEntry("Scale 2x", 9);
	glutAttachMenu(GLUT_RIGHT_BUTTON);
	glutDisplayFunc(display);
	glutReshapeFunc(reshape);
	glutIdleFunc(rotate);
	
	glutMainLoop();
	return 0;
}
