/* CPSC 360 Programming Assignment 3
 * Letters of the alphabet
 * by Chris Bolduc
 * boldu101@chapman.edu
 */

// The commented includes are also in letters.h
//#include <GL/glut.h>
//#include <math.h>
//#include <stdlib.h>
//#include <stdio.h>
#include "letters.h"

#define PI 3.14159

// prototypes
void drawCircle(float radius);
void drawAlpha();
void drawChris();
void drawStroke(char* str);
void drawBitmap(char* str, int row);

// globals
int drawMode = 1;

void init(){
	glClearColor(1.0, 1.0, 1.0, 0.0);
	glMatrixMode(GL_PROJECTION);
	gluOrtho2D(0, 30, 0, 10);
}

// Handles user menu calls.
// Puts the result in displayMode.
void menuFunction(int itemNum){
	drawMode = itemNum;
	glutPostRedisplay();
}

// Displays an item (dependent on menu choice)
void displayItem(){
	glClear(GL_COLOR_BUFFER_BIT);
	
	//glTranslated(1, 3, 0);
	glColor3f(0.0, 0.0, 0.0);
	switch(drawMode){
		case 1:
			printf("Calling bitmap\n");
			drawBitmap("ABCDEFGHIJKLMNOPQRSTUVWXYZ", 0);
			drawBitmap("CHRIS", 1);
			break;
		case 2:
			glPushMatrix();
			drawStroke("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
			glTranslated(-26, 1, 0);
			drawStroke("CHRIS");
			glPopMatrix();
			break;
		case 3:
			glPushMatrix();
			glClear(GL_COLOR_BUFFER_BIT);
			glLineWidth(3.0);
			drawAlpha();
			glTranslated(-20, 1, 0);
			//glTranslated(1, 1, 0);
			drawChris();
			glPopMatrix();
			glFlush();
			break;
	}
	
}

void drawAlpha(){
	draw_A();
	draw_B();
	draw_C();
	draw_D();
	draw_E();
	draw_F();
	draw_G();
	draw_H();
	//draw_I();
	draw_J();
	draw_K();
	draw_L();
	draw_M();
	draw_N();
	draw_O();
	draw_P();
	draw_Q();
	draw_R();
	//draw_S();
	draw_T();
	draw_U();
	draw_V();
	draw_W();
	draw_X();
	draw_Y();
	draw_Z();
	draw_1();
	draw_2();
	//draw_3();
	draw_4();
}

void drawChris(){
	draw_C();
	draw_H();
	draw_R();
	//draw_I();
	//draw_S();
}

void drawStroke(char* str){
	int i;

	for(i = 0; str[i] != '\0'; ++i){
		glPushMatrix();
		glScaled(0.01,0.01,0.0);
		glutStrokeCharacter(GLUT_STROKE_MONO_ROMAN, str[i]);
		glPopMatrix();
		glFlush();
		glTranslated(1, 0, 0);
	}
}

void drawBitmap(char* str, int row){
	int i;

	for(i = 0; str[i] != '\0'; ++i){
		glRasterPos2f(i, row);
		glutBitmapCharacter(GLUT_BITMAP_TIMES_ROMAN_10, str[i]);
		glFlush();
	}
}

//void winReshapeFcn(int newWidth, int newHeight){
//	glClearColor(1.0, 1.0, 1.0, 0.0);
//	glMatrixMode(GL_PROJECTION);
//	gluOrtho2D(LEFT, RIGHT, BOTTOM, TOP);
//	glClear(GL_COLOR_BUFFER_BIT);
//}

int main(int argc, char *argv[]){
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
	glutInitWindowPosition(50, 100);
	glutInitWindowSize(800, 400);
	glutCreateWindow("Example OpenGL Program");

	init();
	glutCreateMenu(menuFunction);
		glutAddMenuEntry("Draw Bitmap",			1 );
		glutAddMenuEntry("Draw Stroke",			2 );
		glutAddMenuEntry("Draw CPSC 360",		3 );

	glutAttachMenu(GLUT_RIGHT_BUTTON);
	glutDisplayFunc(displayItem);
	//glutReshapeFunc(winReshapeFcn);
	glutMainLoop();
	return 0;
}
