/* CPSC 360 Programming Assignment 2
 * Plethora of Primitaves
 * by Chris Bolduc
 * boldu101@chapman.edu
 */

#include <GL/glut.h>
#include <math.h>
#include <stdlib.h>
//#define PI 3.14159
#define LEFT -4
#define RIGHT 4
#define TOP 4
#define BOTTOM -4

void drawPoints();
void drawLines();
void drawLineStrip();
void drawLineLoop();
void drawTriangles();
void drawTriangleStrip();
void drawTriangleFan();
void drawQuads();
void drawQuadStrip();
void drawPolygon();

int displayMode = 1;

void init(){
	glClearColor(1.0, 1.0, 1.0, 0.0);
	glMatrixMode(GL_PROJECTION);
	gluOrtho2D(LEFT, RIGHT, BOTTOM, TOP);
}

// Handles user menu calls.
// Puts the result in displayMode.
void menuFunction(int itemNum){
	displayMode = itemNum;
	glutPostRedisplay();
}

// Displays an item (dependant on menu choice)
void displayItem(){
	glClear(GL_COLOR_BUFFER_BIT);
	//glShadeModel(fillMode);
	//glColor3f(red, green, blue);
	//glBegin(GL_TRIANGLES);
	//	glVertex2i(280, 20);
	//	glVertex2i(160, 280);
	//	glColor3f(red, 0.0, 0.0);
	//	glVertex2i(20, 100);
	//glEnd();
	//glFlush();

	switch(displayMode){
		case 1:  drawPoints();			break;
		case 2:  drawLines();			break;
		case 3:  drawLineStrip();		break;
		case 4:  drawLineLoop();		break;
		case 5:  drawTriangles();		break;
		case 6:  drawTriangleStrip();	break;
		case 7:  drawTriangleFan();		break;
		case 8:  drawQuads();			break;
		case 9:  drawQuadStrip();		break;
		case 10: drawPolygon();			break;
	}
}

// Draws points
void drawPoints(){
	glColor3f(0.0, 0.0, 0.0);
	glPointSize(30.0);
	glBegin(GL_POINTS);
		glVertex2f(-1, -1);
		glVertex2f(-2, -2);
		glVertex2f(-3, -1);
	glEnd();
	glFlush();
}

// Draws lines
void drawLines(){
	glColor3f(0.0, 0.0, 0.0);
	glPointSize(30.0);
	glBegin(GL_POINTS);
		glVertex2f(-3, -3);
		glVertex2f(-3,  3);
		glVertex2f( 3, -3);
		glVertex2f( 3,  3);
	glEnd();
	glColor3f(0.0, 1.0, 0.0);
	glLineWidth(5.0);
	glBegin(GL_LINES);
		glVertex2f(-3, -3);
		glVertex2f(-3,  3);
		glVertex2f( 3, -3);
		glVertex2f( 3,  3);
	glEnd();
	glFlush();
}

// Draws a line strip
void drawLineStrip(){
	glColor3f(0.0, 0.0, 0.0);
	glPointSize(30.0);
	glBegin(GL_POINTS);
		glVertex2f(-3, -3);
		glVertex2f(-3,  3);
		glVertex2f( 3, -3);
		glVertex2f( 3,  3);
	glEnd();
	glColor3f(0.0, 1.0, 0.0);
	glLineWidth(5.0);
	glBegin(GL_LINE_STRIP);
		glVertex2f(-3, -3);
		glVertex2f(-3,  3);
		glVertex2f( 3, -3);
		glVertex2f( 3,  3);
	glEnd();
	glFlush();
}

// Draws a line loop.
void drawLineLoop(){
	glColor3f(0.0, 0.0, 0.0);
	glPointSize(30.0);
	glBegin(GL_POINTS);
		glVertex2f(-3, -3);
		glVertex2f(-3,  3);
		glVertex2f( 3, -3);
		glVertex2f( 3,  3);
	glEnd();
	glColor3f(0.0, 1.0, 0.0);
	glLineWidth(5.0);
	glBegin(GL_LINE_LOOP);
		glVertex2f(-3, -3);
		glVertex2f(-3,  3);
		glVertex2f( 3, -3);
		glVertex2f( 3,  3);
	glEnd();
	glFlush();
}

// Draws triangles.
void drawTriangles(){
	glColor3f(0.0, 0.0, 0.0);
	glPointSize(30.0);
	glBegin(GL_POINTS);
		glVertex2f(1, 1);
		glVertex2f(2, 2);
		glVertex2f(3, 1);
	glEnd();
	glColor3f(1.0, 1.0, 0.0);
	glBegin(GL_TRIANGLES);
		glVertex2f(1, 1);
		glVertex2f(2, 2);
		glVertex2f(3, 1);
	glEnd();
	glFlush();
}

// Draws a triangle strip
void drawTriangleStrip(){
	glColor3f(0.0, 0.0, 0.0);
	glPointSize(30.0);
	glBegin(GL_POINTS);
		glVertex2f(1, 1);
		glVertex2f(2, 2);
		glVertex2f(3, 1);
		glVertex2f(1, 2);
		glVertex2f(0, 1);
	glEnd();
	glColor3f(1.0, 1.0, 0.0);
	glBegin(GL_TRIANGLE_STRIP);
		glVertex2f(1, 1);
		glVertex2f(2, 2);
		glVertex2f(3, 1);
		glVertex2f(1, 2);
		glVertex2f(0, 1);
	glEnd();
	glFlush();
}

// Draws a triangle fan
void drawTriangleFan(){
	glColor3f(0.0, 0.0, 0.0);
	glPointSize(30.0);
	glBegin(GL_POINTS);
		glVertex2f( 0,  0);
		glVertex2f( 2,  2);
		glVertex2f( 2, -2);
		glVertex2f(-2, -2);
		glVertex2f(-2,  2);
	glEnd();
	glColor3f(0.3, 1.0, 0.0);
	glBegin(GL_TRIANGLE_FAN);
		glVertex2f( 0,  0);
		glVertex2f( 2,  2);
		glVertex2f( 2, -2);
		glVertex2f(-2, -2);
		glVertex2f(-2,  2);
	glEnd();
	glFlush();
}

// Draws a quadralateral
void drawQuads(){
	glColor3f(0.0, 0.0, 0.0);
	glPointSize(30.0);
	glBegin(GL_POINTS);
		glVertex2f( 0,  2);
		glVertex2f( 2,  0);
		glVertex2f( 0, -2);
		glVertex2f(-2,  0);
	glEnd();
	glColor3f(0.3, 1.0, 0.0);
	glBegin(GL_QUADS);
		glVertex2f( 0,  2);
		glVertex2f( 2,  0);
		glVertex2f( 0, -2);
		glVertex2f(-2,  0);
	glEnd();
	glFlush();
}

// Draws a quadralateral strip
void drawQuadStrip(){
	glColor3f(0.0, 0.0, 0.0);
	glPointSize(30.0);
	glBegin(GL_POINTS);
		glVertex2f( 0,  2);
		glVertex2f( 2,  2);
		glVertex2f( 2,  0);
		glVertex2f( 2, -2);
		glVertex2f( 0, -2);
		glVertex2f(-2, -2);
		glVertex2f(-2,  0);
		glVertex2f(-2,  2);
	glEnd();
	glColor3f(0.3, 1.0, 0.0);
	glBegin(GL_QUAD_STRIP);
		glVertex2f( 0,  2);
		glVertex2f( 2,  2);
		glVertex2f( 2,  0);
		glVertex2f( 2, -2);
		glVertex2f( 0, -2);
		glVertex2f(-2, -2);
		glVertex2f(-2,  0);
		glVertex2f(-2,  2);
	glEnd();
	glFlush();
}

// Draws a diamond polygon.
void drawPolygon(){
	glColor3f(0.0, 0.0, 0.0);
	glPointSize(30.0);
	glBegin(GL_POINTS);
		glVertex2i( 0,  3);
		glVertex2i( 2,  2);
		//glVertex2i( 3,  0);
		glVertex2i( 2, -2);
		glVertex2i( 0, -3);
		glVertex2i(-2, -2);
		//glVertex2i(-4,  0);
		glVertex2i(-2,  2);
	glEnd();
	glColor3f(0.0, 1.0, 1.0);
	glBegin(GL_POLYGON);
		glVertex2i( 0,  3);
		glVertex2i( 2,  2);
		//glVertex2i( 3,  0);
		glVertex2i( 2, -2);
		glVertex2i( 0, -3);
		glVertex2i(-2, -2);
		//glVertex2i(-4,  0);
		glVertex2i(-2,  2);
	glEnd();
	glFlush();
}

//void winReshapeFcn(int newWidth, int newHeight){
//	glClearColor(1.0, 1.0, 1.0, 0.0);
//	glMatrixMode(GL_PROJECTION);
//	gluOrtho2D(LEFT, RIGHT, BOTTOM, TOP);
//	glClear(GL_COLOR_BUFFER_BIT);
//}

int main(int argc, char *argv[]){
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
	glutInitWindowPosition(50, 100);
	glutInitWindowSize(400, 400);
	glutCreateWindow("Example OpenGL Program");

	init();
	glutCreateMenu(menuFunction);
		glutAddMenuEntry("Draw Points",			1 );
		glutAddMenuEntry("Draw Lines",			2 );
		glutAddMenuEntry("Draw Line Strip",		3 );
		glutAddMenuEntry("Draw Line Loop",		4 );
		glutAddMenuEntry("Draw Triangles",		5 );
		glutAddMenuEntry("Draw Triangle Strip", 6 );
		glutAddMenuEntry("Draw Triangle Fan",	7 );
		glutAddMenuEntry("Draw Quads",			8 );
		glutAddMenuEntry("Draw Quad Strip",		9 );
		glutAddMenuEntry("Draw Polygon",		10);

	glutAttachMenu(GLUT_RIGHT_BUTTON);
	glutDisplayFunc(displayItem);
	//glutReshapeFunc(winReshapeFcn);
	glutMainLoop();
	return 0;
}
