/* CPSC 360 Programming Assignment 1
 * OpenGL Graph of Sine and Cosine Waves
 * by Chris Bolduc
 * boldu101@chapman.edu
 */

#include <GL/glut.h>
#include <math.h>
#include <stdlib.h>
#define PI 3.14159
#define LEFT -2 * PI
#define RIGHT 2 * PI
#define TOP 2
#define BOTTOM -2

void drawAxis();
void drawSineWave();
void drawCosineWave();
void drawHTickMarks();
void drawVTickMarks();

void init(){
	glClearColor(1.0, 1.0, 1.0, 0.0);
	glMatrixMode(GL_PROJECTION);
	gluOrtho2D(LEFT, RIGHT, BOTTOM, TOP);
}

void display_graph(){
	glClear(GL_COLOR_BUFFER_BIT);
	drawAxis();
	wait(5000);
	drawSineWave();
	drawCosineWave();
	drawHTickMarks();
	drawVTickMarks();
}

void drawAxis(){

	glColor3f(1.0, 0.0, 0.0);
	glBegin(GL_LINES);
		glVertex2f(LEFT, 0);
		glVertex2f(RIGHT, 0);
	glEnd();
	glBegin(GL_LINES);
		glVertex2i(0, BOTTOM);
		glVertex2i(0, TOP);
	glEnd();
	glFlush();
}

void drawHTickMarks(){
	const float ivl = 0.5; // interval
	float i = 0.0;
	const float tickSize = 0.2;

	glColor3f(1.0, 0.0, 0.0);
	while(i <= RIGHT){
		glBegin(GL_LINES);
			glVertex2f( i * PI, tickSize / 2 );
			glVertex2f( i * PI, -tickSize / 2 );
		glEnd();
		i += ivl;
	}
	i = 0.0;
	while(i >= LEFT){
		glBegin(GL_LINES);
			glVertex2f( i * PI, tickSize / 2 );
			glVertex2f( i * PI, -tickSize / 2 );
		glEnd();
		i -= ivl;
	}
	glFlush();
}

void drawVTickMarks(){
	const float ivl = 0.5; // interval
	float i = 0.0;
	const float tickSize = 0.2;

	glColor3f(1.0, 0.0, 0.0);
	while(i <= TOP){
		glBegin(GL_LINES);
			glVertex2f( tickSize / 2, i );
			glVertex2f( -tickSize / 2, i );
		glEnd();
		i += ivl;
	}
	i = 0.0;
	while(i >= LEFT){
		glBegin(GL_LINES);
			glVertex2f( tickSize / 2, i );
			glVertex2f( -tickSize / 2, i );
		glEnd();
		i -= ivl;
	}
	glFlush();
}

void drawSineWave(){
	const float ivl = 0.1; // interval
	float i = LEFT - ivl;

	glColor3f(0.0, 1.0, 0.0);
	glBegin(GL_LINE_STRIP);
		while(i < RIGHT){
			glVertex2f( i + ivl, sin(i + ivl) );
			i += ivl;
		}
	glEnd();
	glFlush();
}

void drawCosineWave(){
	const float ivl = 0.1; // interval
	float i = LEFT - ivl;

	glColor3f(0.0, 0.0, 1.0);
	glBegin(GL_LINE_STRIP);
		while(i < RIGHT){
				glVertex2f( i + ivl, cos(i + ivl) );
			i += ivl;
		}
	glEnd();
	glFlush();
}

void winReshapeFcn(int newWidth, int newHeight){
	glClearColor(1.0, 1.0, 1.0, 0.0);
	glMatrixMode(GL_PROJECTION);
	gluOrtho2D(LEFT, RIGHT, BOTTOM, TOP);
	glClear(GL_COLOR_BUFFER_BIT);
}

int main(int argc, char *argv[]){
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
	glutInitWindowPosition(50, 100);
	glutInitWindowSize(400, 300);
	glutCreateWindow("Example OpenGL Program");

	init();
	glutDisplayFunc(display_graph);
	//glutReshapeFunc(winReshapeFcn);
	glutMainLoop();
	return 0;
}
